/*
 * Decompiled with CFR 0.152.
 */
package com.teamaurora.bayou_blues.common.world.biome;

import com.minecraftabnormals.abnormals_core.core.util.DataUtil;
import com.minecraftabnormals.environmental.core.registry.EnvironmentalFeatures;
import com.teamaurora.bayou_blues.core.BayouBluesConfig;
import com.teamaurora.bayou_blues.core.registry.BayouBluesBiomes;
import com.teamaurora.bayou_blues.core.registry.BayouBluesFeatures;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.structure.StructureFeatures;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.MobSpawnInfoBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="bayou_blues")
public class BayouBluesBiomeFeatures {
    @SubscribeEvent
    public static void addFeatures(BiomeLoadingEvent event) {
        ResourceLocation biomeName = event.getName();
        if (biomeName == null) {
            return;
        }
        if (DataUtil.matchesKeys((ResourceLocation)biomeName, (RegistryKey[])new RegistryKey[]{BayouBluesBiomes.BAYOU.getKey(), BayouBluesBiomes.BAYOU_HILLS.getKey()})) {
            BayouBluesBiomeFeatures.withBayouFeatures(event.getGeneration(), event.getSpawns());
        } else if (DataUtil.matchesKeys((ResourceLocation)biomeName, (RegistryKey[])new RegistryKey[]{Biomes.field_76780_h, Biomes.field_150599_m})) {
            BayouBluesBiomeFeatures.withCoolLilyFlowers(event.getGeneration());
        } else if (biomeName.equals((Object)new ResourceLocation("environmental", "blossom_woods")) || biomeName.equals((Object)new ResourceLocation("environmental", "blossom_hills")) || biomeName.equals((Object)new ResourceLocation("environmental", "blossom_highlands")) || biomeName.equals((Object)new ResourceLocation("environmental", "blossom_valleys"))) {
            BayouBluesBiomeFeatures.withWarmLilyFlowers(event.getGeneration());
        }
    }

    public static void withBayouFeatures(BiomeGenerationSettingsBuilder builder, MobSpawnInfoBuilder spawns) {
        DefaultBiomeFeatures.func_243733_b((BiomeGenerationSettings.Builder)builder);
        builder.func_242516_a(StructureFeatures.field_244131_B);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243742_f((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243748_i((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243754_n((BiomeGenerationSettings.Builder)builder);
        builder.func_242513_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, BayouBluesFeatures.Configured.PODZOL);
        if (ModList.get().isLoaded("environmental")) {
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, EnvironmentalFeatures.Configured.DISK_MUD);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.PATCH_GIANT_TALL_GRASS_SAVANNA);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.Configured.PATCH_CATTAILS);
        }
        BayouBluesBiomeFeatures.withBayouVegetation(builder);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243965_y);
        DefaultBiomeFeatures.func_243712_Z((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243721_ae((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243727_ak((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243730_an((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243737_c((MobSpawnInfo.Builder)spawns);
        DefaultBiomeFeatures.func_243714_a((MobSpawnInfo.Builder)spawns);
        spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200743_ai, 1, 1, 1));
    }

    private static void withBayouVegetation(BiomeGenerationSettingsBuilder builder) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, BayouBluesFeatures.Configured.ALGAE);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, BayouBluesFeatures.Configured.TREES_BAYOU);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, BayouBluesFeatures.Configured.TREES_BAYOU_WATER);
        BayouBluesBiomeFeatures.withBayouGrasses(builder);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, BayouBluesFeatures.Configured.FALLEN_CYPRESS_LEAVES);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243928_ck);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243810_aI);
        BayouBluesBiomeFeatures.withAllLilyFlowers(builder);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243882_bb);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243883_bc);
    }

    private static void withBayouGrasses(BiomeGenerationSettingsBuilder builder) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, BayouBluesFeatures.Configured.PATCH_GRASS);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, BayouBluesFeatures.Configured.PATCH_FERN);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, BayouBluesFeatures.Configured.PATCH_GIANT_FERN);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, BayouBluesFeatures.Configured.PATCH_TALL_GRASS);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, BayouBluesFeatures.Configured.PATCH_LARGE_FERN);
    }

    private static void withAllLilyFlowers(BiomeGenerationSettingsBuilder builder) {
        if (((Boolean)BayouBluesConfig.COMMON.doLiliesSpawn.get()).booleanValue()) {
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, BayouBluesFeatures.Configured.PATCH_LILY_COOL);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, BayouBluesFeatures.Configured.PATCH_LILY_NEUTRAL);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, BayouBluesFeatures.Configured.PATCH_LILY_WARM);
        }
    }

    private static void withWarmLilyFlowers(BiomeGenerationSettingsBuilder builder) {
        if (((Boolean)BayouBluesConfig.COMMON.doLiliesSpawn.get()).booleanValue()) {
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, BayouBluesFeatures.Configured.PATCH_LILY_NEUTRAL);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, BayouBluesFeatures.Configured.PATCH_LILY_WARM);
        }
    }

    private static void withCoolLilyFlowers(BiomeGenerationSettingsBuilder builder) {
        if (((Boolean)BayouBluesConfig.COMMON.doLiliesSpawn.get()).booleanValue()) {
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, BayouBluesFeatures.Configured.PATCH_LILY_NEUTRAL);
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, BayouBluesFeatures.Configured.PATCH_LILY_WARM);
        }
    }
}

